<?php
	function GetAttrib($aName, $tag)
	{
		$titlePosStart=strpos($tag, $aName.'="');
		if($titlePosStart)
		{
			$titlePosStart+=strlen($aName)+2;
			$titleLength=strpos($tag, '"', $titlePosStart)-$titlePosStart;
			return substr($tag, $titlePosStart, $titleLength);
		}
		else
			return false;
	}
	
	function GetTextPosition($text)
	{
		$params=explode(' ', $text);
		
		$yPos=$xPos='';
		if(strpos($params[0], 'bottom') >= 0)
			$yPos='bottom';
		else if(strpos($params[0], 'top') >= 0)
			$yPos='top';
		
		if(strpos($params[0], 'right') >= 0)
			$xPos='padding-right';
		else if(strpos($params[0], 'left') >= 0)
			$xPos='padding-left';
			
		$result='style="';
		if(count($params) >= 2)
			$result.=$xPos.':'.$params[1].';';
		if(count($params) >= 3)
			$result.=$yPos.':'.$params[2].';';
		$result.='"';
		
		return $result;
	}
	
	function GetXParam($text, $n)		//numbering from 0
	{
		$params=explode(' ', $text);		
		if(count($params) > $n)
			return $params[$n];
		else
			return '';
	}
	
	function AddBreakLine($text)
	{
		$firstSpace=strrpos($text, ' ');
		if($firstSpace)
		{			
			return substr($text, 0, $firstSpace).'<br/>'.substr($text, $firstSpace+1);
		}
		else
			return $text;
		
	}
	
	function AddBreakLineAfter($text)
	{
		return str_replace('|', '<br/>', $text);
	}
	
	function GetBgImage($forBlock)
	{
		$nid=db_query("SELECT nid FROM node WHERE type='background_images' ORDER BY created DESC LIMIT 1")->fetchField();
		if(!empty($nid))
		{
			$nn=node_load($nid);
			switch($forBlock)
			{
				case "footer" :
					return (!empty($nn->field_footer_background['und']) ? file_create_url($nn->field_footer_background['und'][0]['uri']) : '');
					break;
				case "youtube" :
					return (!empty($nn->field_youtube_background['und']) ? file_create_url($nn->field_youtube_background['und'][0]['uri']) : '');
					break;
			}
		}
		return '';
	}
	
	function GetTextFromLi($str)
	{
		preg_match_all("/\<li\ class=\".*\">(.*)\<\/li\>/", $str, $output_array);
		//var_dump($output_array);die;
		return $output_array;
		//return $str;
	}
?>